#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Going through LSDMod01.fsh  by Flopine   
//https://www.shadertoy.com/view/4ljfDw
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine
// Thanks to wsmind and Leon for teaching me :)


#define PI 3.14

mat2 rot (float angle)
{
    float c = cos(angle);
    float s = sin(angle);
    return mat2 (c,-s,s,c);
}

vec2 moda (vec2 p, float per)
{
    float angle = atan(p.y,p.x);
    float l = length(p);
    angle = mod(angle-per/2., per)-per/2.;
    return vec2(cos(angle),sin(angle))*l;
}


float cylY (vec3 p, float r)
{
  return length(p.xy)-r;  
}

float SDF (vec3 p)
{
    float per = 0.7;
    
    p.x = abs(p.x);   
    p.xy *= rot(p.z+iTime);
    p.xy = moda(p.xy, (sin(iTime)+2.)*PI/4.);
    
    p.yz = mod(p.yz-per/2.,per)-per/2.;           
    p.yz *= rot(p.x+iTime);

    p.x -= .7;
	
    return cylY(p,0.2);
    
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
	vec2 uv = 2.*(fragCoord.xy / iResolution.xy)-1.;
    uv.x *= iResolution.x/iResolution.y;
    
    vec3 pos = vec3(0.001,0.001,iTime*0.8);
    vec3 dir = normalize(vec3(uv, 1.));
    
    float shad = 0.;
    
    
    for (int i=0; i<100; i++)
    {
        float d = SDF(pos);
        if (d<0.01)
        {
            shad = float(i)/60.;
            break;
        }
        else shad = 0.8; 
        pos += d*0.2*dir;
    }
    
    vec3 hue = vec3(abs(pos.y)*3.,1.,.5);
	fragColor = vec4(vec3(shad)/hue,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

